clear all;
close all;

%File details
    delimiterIn = ',';
    headerLinesIn = 0;

    if(exist('PathName','var')==0); PathName = ''; end

%Open the datafile
    FilterSpec = '.dat';
    DialogTitle = 'Select file with T/R data.';
    [posH_Datafile,PathName] = uigetfile(FilterSpec,DialogTitle,PathName);
    imp_Data = importdata([PathName,posH_Datafile],delimiterIn,headerLinesIn);
   
%Checks to see if datafiles are structures
    if(isstruct(imp_Data)); Data=imp_Data.data;
    else Data = imp_Data; end  


    n = size(Data,1);
    j = 1;
    for i = 1:n
        if Data(i,3) >= 2.1 && Data(i,3) <= 9.9
        TT(j) = Data(i,3);
        yy(j) = Data(i,2);
        j = j + 1;
        else
        end
    end

% Plot R/T curve, and check for errors in the average/smoothing process.
    figure;
    hold on;
    box on;
    plot(TT,yy);
    set(gca,'fontsize',15,'fontname','times');
    set(gcf,'color','w');
    xlabel('H (\mu_{0}T)','fontsize',20,'fontname','times');
    ylabel('Resistance (\Omega)','fontsize',20,'fontname','times');
    
% Calculate derivative.
    dRdT = gradient(yy,TT);

% Fit sc transition  
    Data_sc(:,1) = TT;
    Data_sc(:,2) = dRdT;

%Fit gaussian to find Tc midpoint 
    f = fit(TT(:),dRdT(:),'gauss1');
    coeffvals = coeffvalues(f);
    b1 = coeffvals(2);
    c1 = coeffvals(3);

%Plot dR/dT and fit a guassian        
    figure;
    plot(f,Data_sc(:,1),Data_sc(:,2),'xk');
    set(gca,'fontsize',15,'fontname','times');
    set(gcf,'color','w');
    xlabel('\it T (K)','fontsize',20,'fontname','times');
    ylabel('\it dR/dT (arb. units)','fontsize',20,'fontname','times');
    title('FeSeLF8');
    
%Linear fit through the sc transition
    n = size(TT,2);
    j = 1;
    for i = 1:n
        if TT(i) <= (b1+0.5*c1) && TT(i) >= (b1-0.5*c1)
            Tcmid(j,1) = TT(i);
            Tcmid(j,2) = yy(i);
            j = j + 1;
        end
    end
    Tcmid_fit = polyfit(Tcmid(:,1),Tcmid(:,2),1);
    Tcmid_x = 2.1:0.01:9.9;
    Tcmid_y = polyval(Tcmid_fit,Tcmid_x);
    
%Linear fit through sc region
    n = size(TT,2);
    nr = round((n./25));
    j = 1;
    for i = 1:nr
        Tclow(j,1) = TT(i);
        Tclow(j,2) = 0;
        j = j + 1;
    end
    Tclow_fit = polyfit(Tclow(:,1),Tclow(:,2),1);
    Tclow_x = 2.1:0.01:9.9;
    Tclow_y = polyval(Tclow_fit,Tcmid_x);
    
%Linear fit through normal region
    n = size(TT,2);
    nr = round((n./2));
    j = 1;
    for i = (n-nr):n
        Tchigh(j,1) = TT(i);
        Tchigh(j,2) = yy(i);
        j = j + 1;
    end
    Tchigh_fit = polyfit(Tchigh(:,1),Tchigh(:,2),1);
    Tchigh_x = 2.1:0.01:9.9;
    Tchigh_y = polyval(Tchigh_fit,Tchigh_x);
       
%Calculate intercepts
    b0 = InterX([Tclow_x;Tclow_y],[Tcmid_x;Tcmid_y]); 
    b0 = b0(1);
    b2 = InterX([Tcmid_x;Tcmid_y],[Tchigh_x;Tchigh_y]);
    b2 = b2(1);
   
    
%Plot to check linear fits    
    xmin = min(TT); xmax = max(TT);
    ymin = min(yy)-0.5; ymax = max(yy)+0.5;
    figure;
    hold on;
    plot(TT,yy);
    plot(Tcmid_x,Tcmid_y);
    plot(Tclow_x,Tclow_y);
    plot(Tchigh_x,Tchigh_y);
    xlim([xmin xmax]);
    ylim([ymin ymax]);
    set(gca,'fontsize',15,'fontname','times');
    set(gcf,'color','w');
    xlabel('\it T (K)','fontsize',20,'fontname','times');
    ylabel('\it R (\Omega)','fontsize',20,'fontname','times');
    title('FeSeLF8');
    box on;
    
    disp('Offset temperature (K)'); b0
    disp('Mid temperature (K)'); b1
    disp('Onset temperature (K)'); b2
          

            

    
    


